
//======================================
//Circle Math
//======================================
#include <math.h>

#define pi    3.14159265358979323846
#define twopi (2*pi)
float circleradius = 50; //50 each side - make no more any of your max limit values
float stepnumber = 360;
float stepangle;
//======================================


#include <Servo.h> //include servo library for servo control 

Servo horServo; //servo for left/right movement
Servo vertServo; //servo for up/down movement

byte randomhor; //define random horizontal position variable
byte randomvert; //define random vertical position variable
int randomdelay; //define random delay variable

#define HLEFTLIMIT 20 //define left limit on horizontal (left/right) servo
#define HRIGHTLIMIT 80 //define right limit on horizontal (left/right) servo

#define VTOPLIMIT 0//define top limit on vertical (up/down) servo
#define VBOTLIMIT 110 //define bottom limit on horizontal (up/down) servo


void setup() 
{ 
  horServo.attach(8); //horizontal servo on pin 8
  vertServo.attach(9); //vertical servo on pin 9
  randomSeed(analogRead(0)); //Create some random values using an unconnected analog pin


  //=====================================================
  //Roll Eyes :D
  //=====================================================
  stepangle = twopi/stepnumber;
  for(int i = 0; i<stepnumber; i++){
    float angle = i*stepangle;
    float x = sin(angle)*circleradius;
    float y = cos(angle)*circleradius;

    x = map(x, 1-circleradius, circleradius, 0, 2*circleradius);
    y = map(y, 1-circleradius, circleradius, 0, 2*circleradius);

    horServo.write(x); //write to the horizontal servo
    vertServo.write(y); //write to the horizontal servo

    delay(10);
  }
  //=====================================================
} 


void loop() 
{ 
  randomhor = random(HLEFTLIMIT, HRIGHTLIMIT); //set limits
  randomvert = random(VTOPLIMIT, VBOTLIMIT); //set limits
  randomdelay = random(1000, 4000); //moves every 1 to 4 seconds

  horServo.write(randomhor); //write to the horizontal servo
  vertServo.write(randomvert); //write to the vertical servo
  delay(randomdelay); //delay a random amount of time (within values set above)
}  




